// osdtime.cpp : Defines the entry point for the DLL application.
//
// OSD Example plugins
// (c) 2005 Ray Adams
// Updates by Pavel Vlk 
//
//
//
#include "stdafx.h"
#include "resource.h"
HINSTANCE hinstDLLl;
lppatt_proc Main_Proc;
HWND ATT_Win_Handle;
int InitDone=0;
int ShowTime=0;
int ShowRes=0;
int ShowBat=0;

char reg_path[]="SOFTWARE\\Ray Adams\\ATITrayTools\\Profiles\\Plugins\\OSDTime";

void LoadSettings() {
	ShowTime=(IsValueEnabled(reg_path,"ShowTime")) ? 1 : 0;
	ShowRes=(IsValueEnabled(reg_path,"ShowRes")) ? 1 : 0;
	ShowBat=(IsValueEnabled(reg_path,"ShowBat")) ? 1 : 0;

}
BOOL APIENTRY DllMain( HANDLE hModule, 
                       DWORD  ul_reason_for_call, 
                       LPVOID lpReserved
					 )
{
    hinstDLLl=(HINSTANCE)hModule;
	return TRUE;
}

void APIENTRY get_plug_info(PPlugInfo Data) {
	strcpy(Data->Menu_Text,"OSD Example");
	Data->PluginType=PL_OSD;
	Data->Sign=ATT_Sign;
}



bool IsValueEnabled(char *path, char* valuename) {
        HKEY mykey;
        unsigned int value; 
        unsigned long Size=4; 
        RegCreateKeyEx(HKEY_CURRENT_USER,path, 0, NULL, REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS,NULL, &mykey, NULL);
        int m=RegQueryValueEx(mykey,valuename,NULL, NULL, (LPBYTE)&value,&Size);
        RegCloseKey(mykey);
        
        if ((m==ERROR_SUCCESS) && (value==1)) {
                return true;
        } else { return false; }
        
        return true;
}

void WriteValue(char *path, char* valuename, DWORD value) {
        HKEY mykey;
        unsigned long Size=sizeof(DWORD); 
        RegCreateKeyEx(HKEY_CURRENT_USER,path, 0, NULL, REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS,NULL, &mykey, NULL);
        RegSetValueEx(mykey,valuename,0, REG_DWORD,(CONST BYTE *)&value, Size);
        RegCloseKey(mykey);
}

void APIENTRY exec_plugin (HWND Win_Handle, lppatt_proc ATT_Proc) {
	//Initialization stage
	if (InitDone!=0) { return; }

	//Save ATT main window handle
	ATT_Win_Handle=Win_Handle;
	InitDone=1;
	LoadSettings();
}
 
void APIENTRY done_plugin() {
	//
}

void APIENTRY config_plugin(HWND Win_Handle, lppatt_proc ATT_Proc) {
  //Configuration dialog box.
	//must do all initialization temporarily!
	DialogBox(hinstDLLl,MAKEINTRESOURCE(IDD_DIALOG1),Win_Handle,MyDialogProc);
	
	
	//free all temporarily initialized variables
}
void APIENTRY get_osd_string(char* osd_string) {
	if (ShowTime==1) {
		SYSTEMTIME tm;
		GetLocalTime(&tm);
		GetTimeFormat(LOCALE_USER_DEFAULT,0,&tm,NULL,osd_string,255); //"hh':'mm':'ss "
		strcat(osd_string," ");
	}
	if (ShowRes==1) {
		DEVMODE lpDevMode; 
		char resval[50];
		EnumDisplaySettings(NULL,ENUM_CURRENT_SETTINGS,&lpDevMode);     
		sprintf(resval," %dx%dx%d %dHz",lpDevMode.dmPelsWidth,lpDevMode.dmPelsHeight,lpDevMode.dmBitsPerPel, lpDevMode.dmDisplayFrequency);
		strcat(osd_string,resval);
	}
	//Added by Pavel Vlk 
    if (ShowBat==1) {
                SYSTEM_POWER_STATUS pwstat;
				ZeroMemory(&pwstat,sizeof(pwstat));
                char stat[50];
                GetSystemPowerStatus(&pwstat);
                if (pwstat.ACLineStatus==1) strcat(osd_string," Online");
                else {
					if (pwstat.BatteryLifeTime==-1) {
					sprintf(stat," %d%%(?)",pwstat.BatteryLifePercent);
					} else {
					sprintf(stat," %d%%(%dh:%dm)",pwstat.BatteryLifePercent,pwstat.BatteryLifeTime/60/60,pwstat.BatteryLifeTime/60 - (pwstat.BatteryLifeTime/60/60*60));
					}
					strcat(osd_string,stat);
				}
    }

}


void SaveSettings(HWND hwndDlg) {
	ShowTime=(IsDlgButtonChecked(hwndDlg,IDC_CHECK1)) ? 1 : 0;
	ShowRes=(IsDlgButtonChecked(hwndDlg,IDC_CHECK2)) ? 1 : 0;
	ShowBat=(IsDlgButtonChecked(hwndDlg,IDC_CHECK3)) ? 1 : 0;
	WriteValue(reg_path,"ShowTime",ShowTime);
	WriteValue(reg_path,"ShowRes",ShowRes);
	WriteValue(reg_path,"ShowBat",ShowBat);
}

void LoadRegSettings(HWND hwndDlg) {
	
	HWND check1=GetDlgItem(hwndDlg,IDC_CHECK1);
	SetFocus(check1);

	CheckDlgButton(hwndDlg,IDC_CHECK1,(IsValueEnabled(reg_path,"ShowTime")) ? BST_CHECKED : BST_UNCHECKED);
	CheckDlgButton(hwndDlg,IDC_CHECK2,(IsValueEnabled(reg_path,"ShowRes")) ? BST_CHECKED : BST_UNCHECKED);
	CheckDlgButton(hwndDlg,IDC_CHECK3,(IsValueEnabled(reg_path,"ShowBat")) ? BST_CHECKED : BST_UNCHECKED);
}
BOOL CALLBACK MyDialogProc(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam) {
        switch (uMsg) {
            case WM_INITDIALOG:
					LoadRegSettings(hwndDlg);
					return true;
					break;
            case WM_CLOSE: 
                        EndDialog(hwndDlg,0);
                        break;
            case WM_COMMAND: 
                 switch (LOWORD(wParam)) 
                 { 
					case IDOK: 
						SaveSettings(hwndDlg);
						EndDialog(hwndDlg,0);
						break; 
                    case IDCANCEL: 
						EndDialog(hwndDlg,0);
						break; 
				} 
            case WM_KEYDOWN:
                 if (wParam==2) {
					EndDialog(hwndDlg,0);
					return true;
                 }
				 break;

        }
        return FALSE;
	
}